<?php
require_once 'vendor/autoload.php';
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__);
$dotenv->load();

$phone = $_POST['phone'] ?? '';
$otp = $_POST['otp'] ?? '';
$redirect = $_POST['redirect'] ?? ''; // optional redirect URL

if (!$phone || !$otp) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Phone or OTP missing']);
    exit;
}

$mysqli = new mysqli($_ENV['DB_HOST'], $_ENV['DB_USER'], $_ENV['DB_PASS'], $_ENV['DB_NAME']);
$query = "SELECT id FROM otp_requests WHERE phone_number = ? AND otp_code = ? AND is_verified = 0 AND created_at >= (NOW() - INTERVAL 30 MINUTE)";
$stmt = $mysqli->prepare($query);
$stmt->bind_param("ss", $phone, $otp);
$stmt->execute();
$stmt->store_result();

if ($stmt->num_rows > 0) {
    $stmt->bind_result($id);
    $stmt->fetch();

    $update = $mysqli->prepare("UPDATE otp_requests SET is_verified = 1 WHERE id = ?");
    $update->bind_param("i", $id);
    $update->execute();
    $update->close();

    if (!empty($redirect)) {
        header("Location: " . $redirect);
        exit;
    } else {
        echo json_encode(['status' => 'success', 'message' => 'OTP verified']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid or expired OTP']);
}
$stmt->close();
?>

