<?php
require_once 'vendor/autoload.php'; // Load Composer's autoloader
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__);
$dotenv->load();

$phone = $_POST['phone'] ?? '';
if (!$phone) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'No phone number provided']);
    exit;
}

$otp = rand(100000, 999999);

$mysqli = new mysqli($_ENV['DB_HOST'], $_ENV['DB_USER'], $_ENV['DB_PASS'], $_ENV['DB_NAME']);
$stmt = $mysqli->prepare("INSERT INTO otp_requests (phone_number, otp_code, created_at) VALUES (?, ?, NOW())");
$stmt->bind_param("ss", $phone, $otp);
$stmt->execute();
$stmt->close();

$smsData = [
    'messages' => [
        [
            'content' => "Welcome to DownLowCannabis! Use $otp as your login code.",
            'destination' => $phone
        ]
    ]
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://rest.smsportal.com/v1/bulkmessages");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Basic ' . base64_encode($_ENV['SMSPORTAL_USERNAME'] . ':' . $_ENV['SMSPORTAL_PASSWORD']),
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($smsData));

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode == 201) {
    echo json_encode(['status' => 'success', 'message' => 'OTP sent']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to send OTP']);
}
?>
